C      *****************************************************************
C      * Subroutine UpDate(LNum)                                       *
C      * The X vector is the difference between the current guess for  *
C      * concentrations of the components and the next guess according *
C      * to the Newton-Raphson method.  If this difference is larger   *
C      * than or equal to the current guess (implying that the new     *
C      * guess will be negative or zero) a tenth of the guess is taken *
C      * as the new guess.                                             *
C      *                                                               *
C      * Variables:                                                    *
C      * C         -Local - Component index.  Unitless.                *
C      * SpConc    -Output- A matrix, of size NSpecies by NLayers, of  *
C      *                    species concentrations, one set for each   *
C      *                    layer. Units are mol/L.                    *
C      *                    (Common block VModel, file VModel.f)       *
C      * LNum      -Input - The current layer number.  Unitless.       *
C      * X         -Input - A vector of the values of the "Size"       *
C      *                    variables that solve the "Size" equations  *
C      *                    represented in matrix A.  Units are        *
C      *                    consistent with matrix A.                  *
C      *                    (Common block VGauss, file VGauss.f).      *
C      *****************************************************************
       SUBROUTINE UPDATE(LNUM)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INCLUDE 'VGAUSS.INC'
							INTEGER C, LNUM
	   
	      DO 100 C=1,NCOMP
	         IF(X(C).GT.SPCONC(C, LNUM)) THEN
		           SPCONC(C, LNUM) = SPCONC(C, LNUM) / 10.0
		        ELSE
		           SPCONC(C, LNUM) = SPCONC(C, LNUM) - X(C)
		        ENDIF
  100  CONTINUE

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
